<?php
function nug_enqueue_styles() {
    wp_enqueue_style( 'divi-style-parent', get_template_directory_uri() . '/style.css' );
    wp_enqueue_style( 'swiper', 'https://unpkg.com/swiper@8/swiper-bundle.min.css' );
    wp_enqueue_script( 'swiper', 'https://unpkg.com/swiper@8/swiper-bundle.min.js', array(), '8.0.0', true );

}
add_action( 'wp_enqueue_scripts', 'nug_enqueue_styles' );

function nug_footer(){ ?>
    <script>
        //Source: https://stackoverflow.com/a/4770179
        // left: 37, up: 38, right: 39, down: 40,
        // spacebar: 32, pageup: 33, pagedown: 34, end: 35, home: 36
        var keys = {37: 1, 38: 1, 39: 1, 40: 1};

        function preventDefault(e) {
            e.preventDefault();
        }

        function preventDefaultForScrollKeys(e) {
            if (keys[e.keyCode]) {
                preventDefault(e);
                return false;
            }
        }

        // modern Chrome requires { passive: false } when adding event
        var supportsPassive = false;
        try {
            window.addEventListener("test", null, Object.defineProperty({}, 'passive', {
            get: function () { supportsPassive = true; } 
        }));
        } catch(e) {}

        var wheelOpt = supportsPassive ? { passive: false } : false;
        var wheelEvent = 'onwheel' in document.createElement('div') ? 'wheel' : 'mousewheel';

        // call this to Disable
        function disableScroll() {
            window.addEventListener('DOMMouseScroll', preventDefault, false); // older FF
            window.addEventListener(wheelEvent, preventDefault, wheelOpt); // modern desktop
            window.addEventListener('touchmove', preventDefault, wheelOpt); // mobile
            window.addEventListener('keydown', preventDefaultForScrollKeys, false);
        }

        // call this to Enable
        function enableScroll() {
            window.removeEventListener('DOMMouseScroll', preventDefault, false);
            window.removeEventListener(wheelEvent, preventDefault, wheelOpt); 
            window.removeEventListener('touchmove', preventDefault, wheelOpt);
            window.removeEventListener('keydown', preventDefaultForScrollKeys, false);
        }
    </script>
<?php }
add_action( 'wp_footer', 'nug_footer', 99 );

function nug_popup_video(){ ?>
    <div class="video-popup-wrap">
        <div class="popup-overlay"></div>
        <div class="video-popup-content">
            <button class="popup-close"></button>
            <div class="popup-inner"></div>
        </div>
    </div>

    <script>
        //Video Popup

        function getYoutubeId(url) {
            var regExp = /^.*(youtu.be\/|v\/|u\/\w\/|embed\/|watch\?v=|\&v=)([^#\&\?]*).*/;
            var match = url.match(regExp);

            if (match && match[2].length == 11) {
                return match[2];
            } else {
                return 'error';
            }
        }

        let popupInner = document.querySelector('.popup-inner');

        document.querySelectorAll('.nug-popup-video').forEach(video => {


            video.addEventListener("click", function (event) {
                const youtubeURL = video.getAttribute('href');
                const youtubeID = getYoutubeId(youtubeURL);
                let youtubeIframe = '<iframe width="100%" height="500" src="//www.youtube-nocookie.com/embed/' + youtubeID + '?version=3&enablejsapi=1&rel=0&&autoplay=1" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>';

                popupInner.innerHTML = '';

                let div = document.createElement('div');
                div.innerHTML = youtubeIframe;
                popupInner.appendChild(div);

                document.body.classList.toggle("video-popup-opened");


                // console.log('URL: ' + youtubeURL);
                // console.log('ID: ' + youtubeID);


                event.preventDefault();
                return false;
            });
        });

        if (document.querySelector('.popup-overlay')) {
            document.querySelectorAll('.popup-overlay').forEach(overlay => {
                overlay.addEventListener("click", function () {
                    document.body.classList.toggle("video-popup-opened");
                    popupInner.innerHTML = '';
                });
            });
            // document.querySelector('.popup-overlay').addEventListener("click", function () {
            // });
        }

        if (document.querySelector('.popup-close')) {
            document.querySelectorAll('.popup-close').forEach($close => {
                $close.addEventListener("click", function () {
                    document.body.classList.toggle("video-popup-opened");
                    popupInner.innerHTML = '';
                });

            });

        }
    </script>
<?php }
add_action( 'wp_footer', 'nug_popup_video', 99 );

function nug_popup_gallery(){ ?>
    <div class="gallery-popup-wrap">
        <div class="gallery-popup-overlay"></div>
        <div class="gallery-popup-content">
            <button class="gallery-popup-close"></button>
            <div class="gallery-popup-inner">
                <?php if( have_rows('fasilitas') ):
                    while( have_rows('fasilitas') ): the_row(); 
                        $fas_id = get_sub_field('fasilitas_id');
                        $fas_galeri = get_sub_field('fasilitas_galeri');
                        ?>
                        <div id="<?php echo $fas_id; ?>" class="content">
                            <div class="swiper swiper-fasilitas-galeri">
                                <div class="swiper-wrapper">
                                    <?php foreach ($fas_galeri as $galeri) { ?>
                                        <div class="swiper-slide">
                                            <div class="fas-wrap">
                                                <div class="backdrop" style="background-image:url('<?php echo $galeri['url']; ?>');"></div>
                                                <img src="<?php echo $galeri['url']; ?>" class="fas-item">
                                            </div>
                                        </div>
                                    <?php }?>
                                </div>
                                <div class="swiper-pagination"></div>
                            </div>


                            
                        </div>
                    <?php endwhile;
                endif; ?>
            </div>
        </div>
    </div>

    <script>
        let popupInnerGallery = document.querySelector('.popup-inner');

        document.querySelectorAll('.nug-popup-gallery a').forEach(gallery => {
            gallery.addEventListener("click", function (event) {
                document.body.classList.toggle("gallery-popup-opened");
                console.log('target: ' + event.target.parentElement.getAttribute('href'));

                let target = event.target.parentElement.getAttribute('href');
                let targetSelector = document.querySelector(target);

                if (targetSelector) {
                    targetSelector.classList.add('show');
                }
                
                popupInner.innerHTML = '';
                
                event.preventDefault();
                disableScroll();
                
                // return false;
            });
        });

        function galleryClear(e){
            console.log(e.target.outerHTML);
            document.body.classList.toggle("gallery-popup-opened");
            const targetContent = document.querySelectorAll('.gallery-popup-inner .content');
            if (targetContent[0]) {
                targetContent.forEach(e => {
                    e.classList.remove('show');
                });
            }

            enableScroll();

            popupInnerGallery.innerHTML = '';
        }

        if (document.querySelector('.gallery-popup-overlay')) {
            document.querySelectorAll('.gallery-popup-overlay').forEach(overlay => {
                overlay.addEventListener("click", galleryClear);
            });
        }

        if (document.querySelector('.gallery-popup-close')) {
            document.querySelectorAll('.gallery-popup-close').forEach($close => {
                $close.addEventListener("click", galleryClear);
            });
        }

        //Init Swiper
		var swiper = new Swiper(".swiper-fasilitas-galeri", {
			slidesPerView: 1.2,
			spaceBetween: 0,
			loop: true,
			centeredSlides: false,
			watchSlidesProgress: true,
			pagination: {
				el: ".swiper-pagination",
				clickable: true,
			},
			breakpoints: {
				1024: {
					slidesPerView: 1.5,
					centeredSlides: true,
				},
				// 1920: {
				//     slidesPerView: 3.2,
				//     centeredSlides: true,
				// },
				//     768: {
				//         slidesPerView: 4,
				//         spaceBetween: 40,
				//     },
				//     1024: {
				//         slidesPerView: 5,
				//         spaceBetween: 50,
				//     },
			},
		});
    </script>

    
<?php }
add_action( 'wp_footer', 'nug_popup_gallery', 99 );

function nug_testimonial(){ ?>
    <script>
		
		var swiper = new Swiper(".swiper-testimonial", {
			slidesPerView: 1,
			slidesPerGroup: 1,
			spaceBetween: 100,
			loop: true,
			navigation: {
				nextEl: '.swiper-button-next',
				prevEl: '.swiper-button-prev',
			},
			breakpoints: {
				640: {
					slidesPerView: 2,
					slidesPerGroup: 2,
					spaceBetween: 100,
				}
			}
		});
		
      
    </script>
<?php }
add_action( 'wp_footer', 'nug_testimonial', 99 );

include get_stylesheet_directory() . '/sc_testimonial.php';